Attribute VB_Name = "modMain"
Option Explicit
' Set to 0 for Production Mode
#Const DEMO_MODE = 1

#If DEMO_MODE = 1 Then
Private Const MAX_RECORDS = 5
#End If

Private Const DOUBLE_QUOTE = """"
Private Const CHAR_SMALLER = "<"
Private Const CHAR_GREATER = ">"
Private Const CHAR_OBLIQUE_SMALLER = "</"
Private Const CHAR_OBLIQUE_GREATER = " />"

Private Const DEFAULT_INDENTATION = 2

Public Function objRS2XML_DOM(rs As ADODB.Recordset, _
                  strName As String) As MSXML.IXMLDOMElement
   Static objField       As ADODB.Field
   Static intLevel       As Integer
   Static objXMLDocument   As MSXML.DOMDocument
   Static objChild       As MSXML.IXMLDOMElement

   Dim objRoot          As MSXML.IXMLDOMElement
   Dim objElement        As MSXML.IXMLDOMElement
   Dim rsChapter         As ADODB.Recordset
   Dim strDocName        As String
   Dim lngRecCount       As Long

   ' Form a valid Document Name and Record Name
   ' The Document Name ends in "s"; the Record Name doesn't.
   strName = strValidXMLTag(strName)
   If Right$(strName, 1) = "s" Then
      strDocName = strName
      strName = Left$(strName, Len(strName) - 1)
   Else
      strDocName = strName & "s"
   End If

   ' Careful now, this function is recursive!
   If intLevel = 0 Then   ' Only on top-level call.
      Set objXMLDocument = New MSXML.DOMDocument
   End If

   ' Start of Document TAG
   Set objRoot = objXMLDocument.createElement(strDocName)

   intLevel = intLevel + 1

   rs.MoveFirst
   lngRecCount = 1
#If DEMO_MODE = 1 Then
   While Not rs.EOF And lngRecCount < MAX_RECORDS
#Else
   While Not rs.EOF
#End If
      ' Start of Record tag
      Set objElement = objXMLDocument.createElement(strName)
      objRoot.appendChild objElement

      ' Record tag Content
      For Each objField In rs.Fields
         ' Is the Field a Recordset?
         If objField.Type = adChapter Then
            ' We actually have another Recordset,
            ' so we need to recurse
            Set rsChapter = objField.Value
            If Not rsChapter.EOF Then
               objElement.appendChild objRS2XML_DOM(rsChapter, _
                                 strName & "." & objField.Name)
            End If
         Else
            ' We have a regular Field,
            ' so we add it to the XML string

            Set objChild = objXMLDocument.createElement( _
                        strValidXMLTag(strName & "." & objField.Name))
            If Not IsNull(objField.Value) Then
               objChild.Text = strValidXMLContent(objField.Value)
            End If
            objElement.appendChild objChild
         End If
      Next objField

      ' We're done, with this record: fetch next
      DoEvents
      rs.MoveNext
      lngRecCount = lngRecCount + 1
   Wend

   ' The (child) recordset has been processed,
   ' so we decrease the level.
   intLevel = intLevel - 1

   If intLevel = 0 Then   ' Only on top-level call.
      Set objXMLDocument = Nothing
   End If

   ' Finally, return Root element
   Set objRS2XML_DOM = objRoot
   Exit Function

End Function

Private Function strValidXMLTag(strTagCandidate As String) As String
   ' This function only handles occurrences of "xml" and
   ' replaces white space with "_".
   ' The implementation of the remaining rules is left as
   ' an exercise for the reader. ;)

   ' Get rid of occurrences of 'xml'
   strTagCandidate = Replace(strTagCandidate, "xml", "x_m_l")
   ' Get rid of spaces
   strValidXMLTag = Replace(strTagCandidate, " ", "_")
End Function

Private Function strValidXMLContent(strContenCandidate As String) As String
   ' Get rid of occurrences of '<'
   strContenCandidate = Replace(strContenCandidate, "<", "&lt;")
   ' Get rid of occurrences of '>'
   strContenCandidate = Replace(strContenCandidate, ">", "&gt;")
   ' Get rid of occurrences of '&'
   strContenCandidate = Replace(strContenCandidate, "&", "&amp;")
   ' Get rid of occurrences of '"'
   strContenCandidate = Replace(strContenCandidate, """", "&quot;")
   ' Get rid of occurrences of "'"
   strValidXMLContent = Replace(strContenCandidate, "'", "&apos;")
End Function

Public Sub Main()
   Dim strPath          As String

   ' Normalize Path
   strPath = App.Path
   If Right$(strPath, 1) <> "/" Then
      strPath = strPath & "/"
   End If

   CreateAuthorsXML strPath & "Authors.xml"
End Sub

Public Sub CreateAuthorsXML(strXMLFile As String)
   Dim intFileNumber    As Integer
   Dim rsAuthors        As ADODB.Recordset
   Dim objRoot          As MSXML.IXMLDOMElement

   Set rsAuthors = New ADODB.Recordset

   ' Open recordset with a few columns
   ' Limit to just a few records with WHERE clause
   rsAuthors.Source = "SELECT au_id, au_fname, au_lname " _
                    & "FROM Authors WHERE au_id < 5"

   ' In the following, you need to change "srvr" to the
   ' name of your SQL Server
   rsAuthors.ActiveConnection = "Provider=sqloledb;" & _
      "Data Source=srvr;Initial Catalog=pubs;User Id=sa;Password=; "

   ' All set to open recordset...
   rsAuthors.Open   ' Open recordset (limit to just a few records with WHERE clause)

   ' Call objRS2XML_DOM which returns the Root element
   Set objRoot = objRS2XML_DOM(rsAuthors, "Author")

   ' Get unused file number
   intFileNumber = FreeFile
   ' Create file name
   Open strXMLFile For Output As #intFileNumber
   ' Output text
   Print #intFileNumber, objRoot.xml
   ' Close file
   Close #intFileNumber

   ' Clean Up
   rsAuthors.Close
   Set rsAuthors = Nothing
End Sub
